/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.log.analyser;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.log.analyser.LogProcessItem;
import info.msxlaunchers.openmsx.launcher.log.analyser.LogProcessor;
import info.msxlaunchers.openmsx.launcher.log.analyser.processor.LaunchEventProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class LaunchLogProcessor
implements LogProcessor {
    private final Set<LaunchEventProcessor> eventProcessors;

    @Inject
    LaunchLogProcessor(Set<LaunchEventProcessor> eventProcessors) {
        this.eventProcessors = Objects.requireNonNull(eventProcessors);
    }

    @Override
    public final void processMessage(String date, String message) {
        DatabaseItem databaseItem = DatabaseItem.getDatabaseItem(message);
        for (LaunchEventProcessor eventProcessor : this.eventProcessors) {
            eventProcessor.processMessage(date, databaseItem);
        }
    }

    @Override
    public final Map<String, List<String[]>> getProcessedData() {
        HashMap<String, List<String[]>> processedData = new HashMap<String, List<String[]>>();
        for (LaunchEventProcessor eventProcessor : this.eventProcessors) {
            LogProcessItem logProcessItem = eventProcessor.getProcessedData();
            processedData.put(logProcessItem.getKey(), logProcessItem.getItems());
        }
        return Collections.unmodifiableMap(processedData);
    }
}

